/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.server.IVWCommandRPC;
import filenet.vw.server.IVWCommandServer;
import filenet.vw.server.VWCommandRPC;
import filenet.vw.server.VWCommandResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWField;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonHandle;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWSystemWideInfo;
import filenet.vw.server.VWViewIdCommand;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class VWServerCommand
implements Serializable,
IVWCommandRPC {
    private static final long serialVersionUID = 7561L;
    protected VWLogonHandle logonHandle;
    protected VWLogonCredentials logonCreds = null;
    protected Object commandString;
    protected Object commandArgs;
    protected boolean ignoreExceptions;
    protected boolean logonHandleReset;
    protected boolean prefixLogon = false;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Jan 2005 17:30:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   hakpata  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.89  $";
    }

    public VWServerCommand(int rpcNumber, Object[] args) {
        this.commandString = VWCommandRPC.GetName(rpcNumber);
        this.commandArgs = args;
        this.logonHandleReset = false;
    }

    public VWServerCommand(String command, Object[] args) {
        this.commandString = command;
        this.commandArgs = args;
        this.logonHandleReset = false;
    }

    public static VWLogonHandle initLogonHandle() {
        return new VWLogonHandle();
    }

    public void setLogonHandle(VWLogonHandle handle) {
        this.logonHandle = handle;
        this.commonizeLogonHandles();
    }

    public int getIsolatedRegion() {
        int region = 0;
        if (this.logonCreds != null) {
            region = this.logonCreds.getIsolatedRegion();
        }
        return region;
    }

    public void setIsolatedRegion(int isolated_Region) {
        if (this.logonCreds != null) {
            this.logonCreds.setIsolatedRegion(isolated_Region);
        }
    }

    public void setCredentials(VWLogonCredentials logon_creds) {
        this.logonCreds = logon_creds;
        if (logon_creds == null) {
            return;
        }
        if (this.logonHandle == null) {
            this.logonHandle = new VWLogonHandle();
        }
        this.commonizeLogonHandles();
    }

    protected void setLogonHandleReset(boolean isReset) {
        this.logonHandleReset = isReset;
    }

    protected void setIgnoreExceptions(boolean ignore_exceptions) {
        this.ignoreExceptions = ignore_exceptions;
    }

    protected void commonizeLogonHandles() {
        if (this.commandString != null && this.commandString instanceof String) {
            this.commonizeLogonHandles((Object[])this.commandArgs);
        }
    }

    protected void commonizeLogonHandles(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof VWLogonHandle)) continue;
            args[i] = this.logonHandle;
        }
    }

    public static VWServerCommand fromBytes(byte[] bytes, int rpcNumber) throws IOException, ClassNotFoundException, VWException {
        return (VWServerCommand)VWServerCommand.bytesToObject(bytes, rpcNumber);
    }

    public byte[] toBytes(int rpcNumber) throws IOException, VWException {
        try {
            return VWServerCommand.objectToBytes(this, rpcNumber);
        }
        catch (IOException ioe) {
            throw new VWException("vw.server.SCToBytesError", "Error while serializing a command to be sent to the server.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] objectToBytes(Object obj, int rpcNumber) throws IOException, VWException {
        byte[] byArray;
        ObjectOutputStream objOs = null;
        try {
            try {
                byte[] sendBuf;
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                objOs = new ObjectOutputStream(new BufferedOutputStream(byteStream));
                objOs.flush();
                switch (rpcNumber) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 208: 
                    case 209: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 260: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 300: 
                    case 301: 
                    case 350: 
                    case 351: 
                    case 400: {
                        break;
                    }
                    default: {
                        throw new VWException("vw.api.SCInvalidRPCNumber", "Invalid RPC number {0}.", String.valueOf(rpcNumber));
                    }
                }
                objOs.writeObject(((VWServerCommand)obj).logonHandle);
                objOs.writeObject(((VWServerCommand)obj).logonCreds);
                objOs.writeObject(((VWServerCommand)obj).commandString);
                objOs.writeObject(((VWServerCommand)obj).commandArgs);
                objOs.writeBoolean(((VWServerCommand)obj).ignoreExceptions);
                objOs.writeBoolean(((VWServerCommand)obj).logonHandleReset);
                objOs.flush();
                byArray = sendBuf = byteStream.toByteArray();
                Object var7_8 = null;
                if (objOs == null) return byArray;
            }
            catch (IOException iex) {
                throw iex;
            }
            catch (VWException ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (objOs == null) throw throwable;
            try {
                objOs.close();
                objOs = null;
                throw throwable;
            }
            catch (Exception ex) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            // empty catch block
            return byArray;
        }
        objOs.close();
        return byArray;
    }

    protected static Object bytesToObject(byte[] bytes, int rpcNumber) throws IOException, ClassNotFoundException, VWException {
        boolean viewIdCmd = false;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objIs = new ObjectInputStream(new BufferedInputStream(byteStream));
        switch (rpcNumber) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 300: 
            case 301: 
            case 350: 
            case 351: 
            case 400: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 61: 
            case 66: {
                viewIdCmd = true;
                break;
            }
            default: {
                throw new VWException("vw.api.SCInvalidRPCNumber", "Invalid RPC number {0}.", String.valueOf(rpcNumber));
            }
        }
        VWLogonHandle lHandle = (VWLogonHandle)objIs.readObject();
        VWLogonCredentials logonCredentials = (VWLogonCredentials)objIs.readObject();
        String cmdString = (String)objIs.readObject();
        Object[] cmdArgs = (Object[])objIs.readObject();
        boolean iExceptions = objIs.readBoolean();
        boolean lHandleReset = objIs.readBoolean();
        VWServerCommand svrCommand = viewIdCmd ? new VWViewIdCommand(cmdString, cmdArgs) : new VWServerCommand(cmdString, cmdArgs);
        svrCommand.setLogonHandle(lHandle);
        svrCommand.setCredentials(logonCredentials);
        svrCommand.setIgnoreExceptions(iExceptions);
        svrCommand.setLogonHandleReset(lHandleReset);
        return svrCommand;
    }

    public VWCommandResult perform(int rpcNumber, IVWCommandServer cmdServer) throws VWException {
        VWCommandResult result = new VWCommandResult();
        if (this.logonHandle == null || this.logonHandle.getHandle() == 0) {
            result.logonResult = cmdServer.logon(this.logonHandle, this.logonCreds);
            this.setLogonHandle(result.logonResult.logonHandle);
            this.prefixLogon = this.commandString != null;
        } else if (this.logonHandleReset) {
            result.logonResult = cmdServer.logon(this.logonHandle, this.logonCreds);
        }
        try {
            if (this.commandString != null && this.commandString instanceof String) {
                result.commandResult = this.perform(rpcNumber, cmdServer, (Object[])this.commandArgs);
            }
        }
        catch (VWException vwEx) {
            if (this.prefixLogon) {
                try {
                    VWLogonHandle lHandle = null;
                    if (result.logonResult != null) {
                        lHandle = result.logonResult.getLogonHandle();
                    }
                    if (lHandle != null) {
                        result.commandResult = this.perform(2, cmdServer, new Object[]{lHandle});
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw vwEx;
        }
        return result;
    }

    protected Object perform(int rpcNumber, IVWCommandServer cmdServer, Object[] args) throws VWException {
        Object result;
        switch (rpcNumber) {
            case 1: {
                result = cmdServer.logon((VWLogonHandle)args[0], (VWLogonCredentials)args[1]);
                break;
            }
            case 2: {
                cmdServer.logoff((VWLogonHandle)args[0]);
                result = null;
                break;
            }
            case 3: {
                result = cmdServer.getUserNames((VWLogonHandle)args[0]);
                break;
            }
            case 4: {
                result = cmdServer.getConfigInfo((VWLogonHandle)args[0]);
                break;
            }
            case 5: {
                result = cmdServer.getCurrentVersion((VWLogonHandle)args[0]);
                break;
            }
            case 6: {
                result = cmdServer.fetch((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], (Integer)args[4], (String)args[5], (Object[])args[6], (Object[])args[7], (Integer)args[8], (String)args[9], (Object[])args[10], (VWWorkRecord)args[11], (Double)args[12], (Boolean)args[13], (String)args[14]);
                break;
            }
            case 19: {
                result = cmdServer.fetchCount((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], (String)args[4], (Object[])args[5], (Object[])args[6], (Integer)args[7], (String)args[8], (Object[])args[9], (Boolean)args[10], (String)args[11]);
                break;
            }
            case 13: {
                result = cmdServer.fetchUserList((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (String)args[3], (String)args[4], (String)args[5], (Integer)args[6], (Integer)args[7], (Long)args[8]);
                break;
            }
            case 7: {
                result = cmdServer.getWorkElementFields((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID[])args[3], (Integer)args[4], (Boolean)args[5], (Boolean)args[6], (Boolean)args[7], (Integer)args[8], (Integer)args[9]);
                break;
            }
            case 8: {
                result = cmdServer.unlockSave((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID[])args[3], (Integer)args[4], (VWField[][])args[5], (Boolean)args[6], (String)args[7], (String)args[8], (String)args[9], (Boolean)args[10], (Boolean)args[11], (Boolean)args[12], (Boolean)args[13], (Boolean)args[14]);
                break;
            }
            case 9: {
                result = cmdServer.getLockStatus((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID[])args[3], (Boolean)args[4], (Boolean)args[5]);
                break;
            }
            case 10: {
                result = cmdServer.terminateWorkObject((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID[])args[3], (Boolean)args[4], (Boolean)args[5]);
                break;
            }
            case 15: {
                result = cmdServer.getNewStepElement((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 16: {
                result = cmdServer.saveNewStepElement((VWLogonHandle)args[0], (VWField[])args[1], (String)args[2], (Integer)args[3]);
                break;
            }
            case 17: {
                result = cmdServer.getNewStepFromVWVersion((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 18: {
                result = cmdServer.checkVWVersion((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 11: {
                result = cmdServer.getLoggingState((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2]);
                break;
            }
            case 12: {
                result = cmdServer.getAllServers((VWLogonHandle)args[0]);
                break;
            }
            case 30: {
                result = cmdServer.recoverUser((VWLogonHandle)args[0], (String)args[1], (String[])args[2]);
                break;
            }
            case 31: {
                result = cmdServer.getQueueNames((VWLogonHandle)args[0], (Boolean)args[1], (Boolean)args[2]);
                break;
            }
            case 350: {
                result = cmdServer.getLogNames((VWLogonHandle)args[0]);
                break;
            }
            case 40: {
                result = cmdServer.getQueueOperations((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 32: {
                result = cmdServer.getQueueDepth((VWLogonHandle)args[0], (Integer)args[1], (Boolean)args[2]);
                break;
            }
            case 33: {
                cmdServer.logMessage((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (String)args[3]);
                result = null;
                break;
            }
            case 34: {
                result = cmdServer.getExposedFields((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 35: {
                result = cmdServer.getIndexFields((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 60: {
                result = cmdServer.getRosterNames((VWLogonHandle)args[0], (Boolean)args[1]);
                break;
            }
            case 20: {
                result = cmdServer.getWorkClassNames((VWLogonHandle)args[0], (Boolean)args[1], (String)args[2]);
                break;
            }
            case 26: {
                result = cmdServer.getAttributes((VWLogonHandle)args[0], (Integer)args[1]);
                break;
            }
            case 21: {
                result = cmdServer.getProcess((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (String)args[3]);
                break;
            }
            case 61: {
                result = cmdServer.getRosterCount((VWLogonHandle)args[0], (Integer)args[1]);
                break;
            }
            case 62: {
                result = cmdServer.getNewWorkObjectFields((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 63: {
                result = cmdServer.inject((VWLogonHandle)args[0], (String)args[1], (VWField[][])args[2], (String[])args[3], (String)args[4], (String)args[5]);
                break;
            }
            case 64: {
                result = cmdServer.getInjectSessionInfo((VWLogonHandle)args[0], (String)args[1], (String)args[2], (Boolean)args[3]);
                break;
            }
            case 65: {
                result = cmdServer.deleteInjectSession((VWLogonHandle)args[0], (String)args[1], (String)args[2]);
                break;
            }
            case 200: {
                cmdServer.initializeAllRegions((VWLogonHandle)args[0]);
                result = null;
                break;
            }
            case 201: {
                cmdServer.initializeRegion((VWLogonHandle)args[0], (Boolean)args[1], (Integer)args[2]);
                result = null;
                break;
            }
            case 202: {
                cmdServer.removeDatabase((VWLogonHandle)args[0]);
                result = null;
                break;
            }
            case 203: {
                result = cmdServer.getSystemWideConfig((VWLogonHandle)args[0]);
                break;
            }
            case 204: {
                cmdServer.setSystemWideConfig((VWLogonHandle)args[0], (VWSystemWideInfo)args[1]);
                result = null;
                break;
            }
            case 205: {
                result = cmdServer.fetchUserInfo((VWLogonHandle)args[0], (String[])args[1]);
                break;
            }
            case 206: {
                cmdServer.saveUserInfo((VWLogonHandle)args[0], (VWEnvironmentData)args[1]);
                result = null;
                break;
            }
            case 207: {
                cmdServer.deleteUserInfo((VWLogonHandle)args[0], (String)args[1]);
                result = null;
                break;
            }
            case 300: {
                result = cmdServer.getSystemConfigInfo((VWLogonHandle)args[0], (Integer)args[1]);
                break;
            }
            case 301: {
                result = cmdServer.transfer((VWLogonHandle)args[0], (VWLogonCredentials)args[1], (VWSystemConfigInfo)args[2], (VWWorkflowDefinition)args[3], (String)args[4], (Boolean)args[5], (Boolean)args[6], (Integer)args[7]);
                break;
            }
            case 67: {
                result = cmdServer.getRosterDefinition((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 39: {
                result = cmdServer.getQueueDefinition((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 351: {
                result = cmdServer.getLogDefinition((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 36: {
                cmdServer.doReject((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID)args[3], (Integer)args[4]);
                result = null;
                break;
            }
            case 37: {
                cmdServer.doReassign((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID)args[3], (Integer)args[4], (String)args[5], (String)args[6], (Boolean)args[7], (String)args[8], (VWField[])args[9], (String)args[10], (String)args[11], (Boolean)args[12], (Boolean)args[13], (Boolean)args[14], (Long)args[15]);
                result = null;
                break;
            }
            case 41: {
                cmdServer.doReturn((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID)args[3], (Integer)args[4], (VWField[])args[5], (String)args[6], (String)args[7], (Boolean)args[8], (Boolean)args[9], (Boolean)args[10]);
                result = null;
                break;
            }
            case 38: {
                result = cmdServer.getQueueStatistics((VWLogonHandle)args[0], (Integer)args[1], (Date)args[2], (Date)args[3], (Integer)args[4]);
                break;
            }
            case 66: {
                result = cmdServer.getRosterStatistics((VWLogonHandle)args[0], (Integer)args[1], (Date)args[2], (Date)args[3], (Integer)args[4]);
                break;
            }
            case 14: {
                result = cmdServer.isMemberOfGroup((VWLogonHandle)args[0], (String)args[1], (String)args[2], (Long)args[3]);
                break;
            }
            case 28: {
                result = cmdServer.fetchIsGroup((VWLogonHandle)args[0], (String[])args[1]);
                break;
            }
            case 208: {
                cmdServer.removeLinkFlag((VWLogonHandle)args[0], (String)args[1]);
                result = null;
                break;
            }
            case 250: {
                result = cmdServer.getStepProcessorList((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2]);
                break;
            }
            case 251: {
                result = cmdServer.getLaunchStepProcessor((VWLogonHandle)args[0], (String)args[1], (Integer)args[2]);
                break;
            }
            case 252: {
                result = cmdServer.getStepProcessorByName((VWLogonHandle)args[0], (String)args[1], (Integer)args[2]);
                break;
            }
            case 253: {
                result = cmdServer.getStepProcessorById((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2]);
                break;
            }
            case 22: {
                result = cmdServer.createLiveWorkObject((VWLogonHandle)args[0], (VWField[])args[1], (String)args[2], (Integer)args[3]);
                break;
            }
            case 23: {
                result = cmdServer.getWorkflowSignature((VWLogonHandle)args[0], (String)args[1]);
                break;
            }
            case 267: {
                result = cmdServer.getFileFromServer((VWLogonHandle)args[0], (String)args[1], (Integer)args[2]);
                break;
            }
            case 268: {
                result = cmdServer.getLimitApplicationFunctionalityFlag((VWLogonHandle)args[0]);
                break;
            }
            case 24: {
                result = cmdServer.getWorkClassXML((VWLogonHandle)args[0], (Integer)args[1], (String)args[2], (Boolean)args[3], (Boolean)args[4]);
                break;
            }
            case 25: {
                result = cmdServer.deleteWorkObject((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID[])args[3], (Boolean)args[4], (Boolean)args[5], (Boolean)args[6], (Boolean)args[7]);
                break;
            }
            case 27: {
                result = cmdServer.getReturnStackElements((VWLogonHandle)args[0], (Integer)args[1], (Integer)args[2], (VWWorkObjectID)args[3], (Boolean)args[4]);
                break;
            }
            case 261: {
                result = cmdServer.convertSecurityNamestoIds((VWLogonHandle)args[0], (String[])args[1], (Boolean)args[2]);
                break;
            }
            case 260: {
                result = cmdServer.convertSecurityIdstoNames((VWLogonHandle)args[0], (Long[])args[1]);
                break;
            }
            case 262: {
                result = cmdServer.fetchAttachmentIsReferenced((VWLogonHandle)args[0], (VWAttachment[])args[1]);
                break;
            }
            case 263: {
                result = cmdServer.fetchAttachmentIsReferencedBy((VWLogonHandle)args[0], (VWAttachment)args[1], (Integer)args[2], (Integer)args[3], (String)args[4]);
                break;
            }
            case 264: {
                result = cmdServer.fetchServerConfiguration((VWLogonHandle)args[0], (String[])args[1]);
                break;
            }
            case 209: {
                result = cmdServer.fetchUserEnvironmentRecords((VWLogonHandle)args[0], (Integer)args[1], (VWEnvironmentData)args[2], (Boolean)args[3]);
                break;
            }
            case 265: {
                result = cmdServer.fetchSecurityDomains((VWLogonHandle)args[0]);
                break;
            }
            case 266: {
                result = cmdServer.fetchParticipants((VWLogonHandle)args[0], (String)args[1], (String[])args[2], (Long)args[3]);
                break;
            }
            default: {
                throw new VWException("vw.server.SCUnknownCommand", "Unknown command.");
            }
        }
        return result;
    }

    public boolean hasValidLogonHandle() {
        try {
            return this.logonCreds != null && this.logonCreds.getUserName() != null || this.logonHandle != null && this.logonHandle.getHandle() != 0 && !this.logonHandleReset;
        }
        catch (Exception e) {
            return false;
        }
    }
}

